### NAME

djbsort-speed - run some djbsort speed tests

### SYNOPSIS

    djbsort-speed

### DESCRIPTION

`djbsort-speed`
runs some tests of the speed of the djbsort library.

The `djbsort-speed` output format is subject to change.
Examples of output lines with the current format,
from a `djbsort-speed` run on an AMD Zen 3 CPU core,
include the following:

    sort_int32 selected implementation avx2 compiler gcc -Wall -fPIC -fwrapv -O2 -mmmx -msse -msse2 -msse3 -mssse3 -msse4.1 -msse4.2 -mavx -mbmi -mbmi2 -mpopcnt -mavx2 -mtune=haswell; gcc (Debian 12.2.0-14+deb12u1) 12.2.0; Copyright (C) 2022 Free Software Foundation, Inc.; This is free software; see the source for copying conditions.  There is NO; warranty; not even for MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
    sort_int32 selected 1597 8769 +1335+200-12+36-20-70+20-61-25+57-55+26+4-22+10+0+26-1-70-41+53-59-25+57-55+26+4-22+10+0+26-1

These lines say that the automatically selected implementation for `djbsort_int32`
was the `avx2` implementation compiled with the `clang` options shown,
taking an interquartile mean (IQM) of 8769 CPU cycles to sort an `int32[1597]` array.
The numbers `8769 +1335+200+...` show the timings for a series of consecutive operations:
the IQM was 8769 cycles,
the first run took 1335 cycles more than the IQM,
the second run took 200 cycles more than the IQM,
etc.

### SEE ALSO

**djbsort**(3)
