#!/usr/bin/env python3

with open('bench.cc') as f:
  bench = f.readlines()

for bits in 32,64:
  for sort in 'aspas','djbsort','far','herf','stdsort','vqsort','vxsort','x86simdsort':
    if sort == 'aspas' and bits != 32: continue
    if sort == 'far' and bits != 32: continue
    if sort == 'herf' and bits != 32: continue
    with open(f'bench{bits}-{sort}.cc','w') as f:
      f.write('/* WARNING: auto-generated (by sortbench/benchgen.py); do not edit */\n\n')
      for line in bench:
        if line.startswith(f'@{bits}: '):
          line = line[len(f'@{bits}: '):]
        if line.startswith(f'@{sort}: '):
          line = line[len(f'@{sort}: '):]
        if not line.startswith('@'):
          f.write(line)
